<?php $__env->startSection('title'); ?>
    Admin | All Data
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <?php echo $__env->make('back.parts.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <div class="col-md-6">
                        <h6 class="m-0 font-weight-bold text-primary">All Work</h6>
                    </div>
                    <div class="col-md-6">
                        <a href="<?php echo e(route('work.create')); ?>" class="btn btn-primary float-right ">Add New</a>
                        <a href="<?php echo e(route('work.type.index')); ?>" class="btn btn-primary float-right mr-2">Type</a>
                    </div>
                </div>
                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                            <tr>
                                <th class="text-center col__id">ID</th>
                                <th>Type</th>
                                <th>Name</th>
                                <th class="text-center">Images</th>
                                <th class="col__action__body">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center"><?php echo e($item->id); ?></td>
                                    <td><?php echo e(optional($item->workType)->name); ?></td>
                                    
                                    <td><?php echo e($item->name); ?></td>
                                    <td class="text-center">
                                        <?php $__currentLoopData = $item->images ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <img src="<?php echo e(asset($image)); ?>" alt="Image" 
                                                style="height:50px; width:auto; border:1px solid #ddd; padding:3px; border-radius:5px;">
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    
                                    <td class="col__action__body">
                                        <a title="view" target="_blank" href="<?php echo e(route('work.single',['id'=>$item->id,'slug'=>$item->slug])); ?>" class="btn btn-success btn-sm">View</a>
                                        <a href="<?php echo e(route('work.edit', ['id' => $item->id])); ?>"
                                           class="btn btn-info btn-sm">Edit</a>
                                        <a href="<?php echo e(route('work.destroy', ['id' => $item->id])); ?>"
                                           onclick="return confirm('Are you sure to delete this!')"
                                           class="btn btn-danger btn-sm">Delete</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-left mt-4">
                            <?php echo e($items->links('pagination::bootstrap-4')); ?>

                        </div>
                    </div>
            </div>
        </div>
    </div>
</div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/studiol3/dev.studiolooper.com/resources/views/back/work/index.blade.php ENDPATH**/ ?>