@extends('layouts.frontend')
@section('meta_info')
    <title>Return Policy | {{ setting('site_title') }}</title>
    <meta name="description" content="{{ setting('meta_description') }}">
    <meta name="keywords" content="{{ setting('meta_keywords') }}">
    <meta name="author" content="{{ setting('meta_author') }}">
@endsection
@section('content')
    <section class="container pb-5 mb-md-2 mb-lg-4">
        <h3 class="border-bottom pb-4">Return Policy</h3>
        <div class="row pt-2 pt-md-3">
            <div class="col-md-12">
                <p class="fs-lg pe-lg-4 mb-1 mb-lg-4">
                    At HOTELIERS, we strive to ensure transparency and fairness in all transactions. We deeply
                    appreciate your generosity and support. However, we understand that circumstances may arise where
                    you need clarification or assistance regarding your contributions. Please review our Return Policy
                    based on the type of payment.</p>

                <h4>Non-Refundable Payments</h4>
                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Donations and Contributions: All donations and contributions made to HOTELIERS are final and non-refundable through our payment gateway, as they directly support our initiatives and operations.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Registrations: Some event payments are non-refundable once the registration is confirmed as stated during the booking process.
                    </li>
                </ul>

                <h4>Refundable Payments</h4>
                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        <b>Hotel Bookings: </b> Refunds are subject to the cancellation policy of the respective booking and hotel. Please check the terms before booking.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        <b>Ticket Purchases: </b> Refunds may be available for canceled events. Contact us for details.
                    </li>
                </ul>

            </div>
        </div>
    </section>
@endsection
