@extends('layouts.frontend')
@section('meta_info')
    <title>{{ setting('site_title') }}</title>
    <meta name="description" content="{{ setting('meta_description') }}">
    <meta name="keywords" content="{{ setting('meta_keywords') }}">
    <meta name="author" content="{{ setting('meta_author') }}">
@endsection
@section('content')
    <section class="container pb-5 mb-md-2 mb-lg-4">
        <h3 class="border-bottom pb-4">Privacy Policy</h3>
        <div class="row pt-2 pt-md-3">
            <div class="col-md-12">
                <p class="fs-lg pe-lg-4 mb-1 mb-lg-4">
                    At <a href="https://hoteliersbd.com/">HOTELIERS</a>, we are committed to protecting your privacy and
                    ensuring the security of your personal
                    and financial information. This Privacy Policy outlines how we collect, use, and safeguard your data
                    when you interact with our website, services, payment gateway, and initiatives.
                    We, the hoteliers, started the Hoteliers Iftar Get-Together in 2016.</p>

                <h4>What We Collect</h4>

                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Personal information (e.g., name, email, contact details) provided voluntarily by you.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Non-personal information (e.g., browsing behavior, device information) collected through cookies
                        and
                        analytics tools.
                    </li>
                </ul>

                <h4>How We Use Your Information</h4>

                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        To provide and improve our services, programs, and initiatives.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        To communicate with you about updates, events, and opportunities.
                    </li>

                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        To process donations or contributions securely.
                    </li>

                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        To analyze website usage and enhance user experience.
                    </li>
                </ul>

                <h4>Data Security</h4>
                <p>We implement industry-standard encryption (SSL/TLS) to protect your data during transactions and
                    security measures to protect your information from unauthorized access, misuse, or disclosure and
                    processed by trusted payment processors.</p>

                <h4>Third-Party Sharing</h4>
                <p>We do not sell or share your personal information with third parties unless required by law and legal
                    compliance or with your explicit consent.</p>
                <h4>Your Rights</h4>
                <p>You have the right to access, update, or request the deletion of your personal information at any
                    time. To do so, please contact us at support@hoteliersbd.com.</p>
                <p>By using our website, payment gateway and services, you agree to the terms outlined in this Privacy
                    Policy. We may update this policy periodically, and any changes will be posted on this page.</p>
            </div>
        </div>
    </section>
@endsection
