@extends('layouts.frontend')
@section('meta_info')
    <title>Our Plan | {{ setting('site_title') }}</title>
    <meta name="description" content="{{ setting('meta_description') }}">
    <meta name="keywords" content="{{ setting('meta_keywords') }}">
    <meta name="author" content="{{ setting('meta_author') }}">
@endsection
@section('content')
    <section class="container pb-5 mb-md-2 mb-lg-4">
        <h3 class="border-bottom pb-4">Our Plan</h3>
        <div class="row pt-2 pt-md-3">
            <div class="col-md-12">
                <p class="fs-lg pe-lg-4 mb-1 mb-lg-4">
                    At <a href="https://hoteliersbd.com/">HOTELIERS</a>, we are committed to continuously evolving and
                    expanding our impact on the hospitality industry. Our future plans reflect our dedication to
                    empowering associates, fostering team bonding and creating a more inclusive and sustainable future
                    and shaping a brighter future for hospitality associates. Our upcoming initiatives are designed to
                    empower, educate and entertain, ensuring every associate thrives both personally and professionally.
                </p>

                <h4>Hospitality Industry Associates Association</h4>
                <p>We plan to establish a formal Hospitality Industry Associates Association to represent the interests
                    of
                    hospitality professionals. This association will:</p>
                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Collaborate with government bodies to ensure fair laws and policies for associates.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Advocate for better working conditions, wages and benefits.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Provide a unified voice for associates to address industry challenges.
                    </li>
                </ul>

                <h4>Hoteliers Club for Associates Entertainment</h4>
                <p>We believe in the importance of work-life balance. Our Hoteliers Club will offer:</p>
                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Fun and engaging events to foster camaraderie and relaxation.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Recreational activities to build stronger team bonds.
                    </li>

                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        A supportive community where associates can unwind and connect.
                    </li>
                </ul>

                <h4>Learning and Training Sessions</h4>
                <p>To support continuous growth we will host training and development programs focused on:</p>
                <ul class="list-unstyled d-md-none d-lg-block pb-1 pb-xl-0 mb-4 mb-xl-5">
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Skill-building workshops to enhance professional expertise.
                    </li>
                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Leadership and career development sessions.
                    </li>

                    <li class="d-flex align-items-center mb-2">
                        <i class="bx bx-check-circle fs-xl text-primary me-2"></i>
                        Industry-specific knowledge to keep associates ahead in their field.
                    </li>
                </ul>

                <h4>Expanding Support Programs</h4>
                <p>We aim to launch the same initiatives that we started during COVID to provide financial support who
                    were jobless forcefully along with emotional, and professional support to hospitality associates in
                    need ensuring no one is left behind.</p>

                <h4>Building a Global Community</h4>
                <p>Our goal is to connect hospitality professionals worldwide, creating a network of support,
                    collaboration and shared learning.</p>
                <h4>Enhancing Team Bonding</h4>
                <p>We plan to develop innovative tools and programs that strengthen team dynamics, promote inclusivity
                    and create happier more productive workplaces.</p>
                <h4>Advocating for Industry Change</h4>
                <p>We will work closely with industry leaders to advocate for better working conditions, fair wages and
                    sustainable practices.</p>
                <h4>Leveraging Technology</h4>
                <p>By integrating cutting-edge technology, we aim to streamline our services, making it easier for
                    associates to access resources and for supporters to contribute to our cause. Through these initiatives, we aim to create a holistic ecosystem where associates feel valued,
                    supported and inspired to excel. Together, we can build a future where hospitality professionals
                    thrive in every aspect of their lives.</p>
                <p>Together we are building a brighter future for the hospitality industry—one where every associate
                    feels valued, supported, and inspired. Join us on this journey!</p>
            </div>
        </div>
    </section>
@endsection
