@extends('layouts.frontend')
@section('meta_info')
    @php
        $setting = setting();
    @endphp
    <title>{{ $setting->site_title }}</title>
    <meta name="title" content="{{ $setting->site_title }}"/>
    <meta name="keywords" content="{{ $setting->meta_keywords }}"/>
    <meta name="description" content="{{ $setting->meta_description }}">
    <meta name="author" content="{{$setting->meta_author}}">
    <meta property="og:title" content="{{ $setting->meta_title }}"/>
    <meta property="og:description" content="{{ $setting->meta_description }}">
    <meta property="og:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
    <meta property="og:url" content="{{$setting->site_url}}"/>
    <meta property="og:site_name" content="{{ $setting->site_name }}">
    <meta name="twitter:url" content="{{ $setting->site_url }}"/>
    <meta name="twitter:title" content="{{ $setting->meta_title }}"/>
    <meta name="twitter:description" content="{{ $setting->meta_description }}"/>
    <meta name="twitter:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
@endsection
@section('content')
<!-------------Slider----------------->  
  <div id="home" class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="mt-4"><h1 id="hero-text">Where <span style="color: rgb(255, 193, 14); font-weight:900;"> Ideas</span><br>
                        Find Their <span>Loop.</span></h1>
                    </div>
                    <hr>
                    <div class="mt-4"><h4 id="sub_title">"Creativity is 
                        intelligence having fun.”</h1>
                    </div>
                      <p class=" qoute">— Albert Einstein</p>
                     <hr> 
                    <p id="hero-p">Welcome to Studio Looper — where ideas come alive, colors command attention,
                        and brands step boldly into their spotlight. With over 15 years shaping the
                        advertising and branding landscape in Bangladesh, we blend fearless creativity with
                        deep market insight, crafting stories and designs that connect, persuade, and leave
                        a lasting mark. </p>
                        <p id="hero-p">From big campaigns to precision-crafted visuals, we believe advertising should be
                        as fun as it is effective — bold enough to turn heads and smart enough to deliver real
                        results. Armed with local knowledge and global vision, we help brands of all sizes
                        stand out, sell better, and stay unforgettable.</p>  <p id="hero-p">If you’re ready to give your brand a
                        powerful edge, <span>it’s time to loop with us.</span></p>
              
                </div>
            </div>
        </div>
        <div class="container mt-5">
            <div class="row d-flex justify-content-between align-items-center">
                <div class="col-md-6">
                    <div class="mb-0"><h6 id="hero-h6" class="mb-0">Let’s Talk <a href="./contact-us"><img
                            class="hero-img" style="width:35px;height:35px;" src="{{ asset('assets/media/Forward Icon_Yellow.a55e1a6f.svg') }}" alt=""></a>
                    </h6></div>
                </div>
             
            </div>
        </div>
        <!--<div id="client-review" class="container-fluid">-->
        <!--    <div id="testimonial" class="container">-->
        <!--        <div class="row" style="margin-bottom: 4rem;">-->
        <!--            <div class="col">-->
        <!--                <div class="caro carousel slide">-->
        <!--                    <ol class="carousel-indicators">-->
        <!--                        <li class="active"></li>-->
        <!--                        <li></li>-->
        <!--                        <li></li>-->
        <!--                    </ol>-->
        <!--                    <div class="carousel-inner">-->
        <!--                        <div class="active carousel-item">-->
        <!--                            <div>-->
        <!--                                <div class="c-img"><img class="c-img-style" src="/static/media/C1.2c0dbcb7.png"-->
        <!--                                                        alt="Customer Img"></div>-->
        <!--                                <div class="mt-3"><p><strong> Ahmad H. Sabbir </strong></p></div>-->
        <!--                                <p> Brand Artist, Studio Looper</p>-->
        <!--                                <div><p class="mb-3">Lorem ipsum dolor sit amet consectetur adipisicing elit.-->
        <!--                                    Saepe maiores unde iusto. Suscipit exercitationem sed, labore corrupti-->
        <!--                                    impedit beatae minus.</p></div>-->
        <!--                            </div>-->
        <!--                        </div>-->
        <!--                        <div class="carousel-item">-->
        <!--                            <div>-->
        <!--                                <div class="c-img"><img class="c-img-style" src="/static/media/C1.2c0dbcb7.png"-->
        <!--                                                        alt="Customer Img"></div>-->
        <!--                                <div class="mt-3"><p><strong> Ahmad H. Sabbir </strong></p></div>-->
        <!--                                <p> Brand Artist, Studio Looper</p>-->
        <!--                                <div><p class="mb-3">Lorem ipsum dolor sit amet consectetur adipisicing elit.-->
        <!--                                    Saepe maiores unde iusto. Suscipit exercitationem sed, labore corrupti-->
        <!--                                    impedit beatae minus.</p></div>-->
        <!--                            </div>-->
        <!--                        </div>-->
        <!--                        <div class="carousel-item">-->
        <!--                            <div>-->
        <!--                                <div class="c-img"><img class="c-img-style" src="/static/media/C1.2c0dbcb7.png"-->
        <!--                                                        alt="Customer Img"></div>-->
        <!--                                <div class="mt-3"><p><strong> Ahmad H. Sabbir </strong></p></div>-->
        <!--                                <p> Brand Artist, Studio Looper</p>-->
        <!--                                <div><p class="mb-3">Lorem ipsum dolor sit amet consectetur adipisicing elit.-->
        <!--                                    Saepe maiores unde iusto. Suscipit exercitationem sed, labore corrupti-->
        <!--                                    impedit beatae minus.</p></div>-->
        <!--                            </div>-->
        <!--                        </div>-->
        <!--                    </div>-->
        <!--                    <a class="carousel-control-prev" role="button" href="#"><span aria-hidden="true"-->
        <!--                                                                                  class="carousel-control-prev-icon"></span><span-->
        <!--                            class="sr-only">Previous</span></a><a class="carousel-control-next" role="button"-->
        <!--                                                                  href="#"><span aria-hidden="true"-->
        <!--                                                                                 class="carousel-control-next-icon"></span><span-->
        <!--                        class="sr-only">Next</span></a></div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    
@endsection
