@extends('layouts.frontend')
@section('meta_info')
    @php
        $setting = setting();
    @endphp
    <title>{{ $setting->site_title }}</title>
    <meta name="title" content="{{ $setting->site_title }}" />
    <meta name="keywords" content="{{ $setting->meta_keywords }}" />
    <meta name="description" content="{{ $setting->meta_description }}">
    <meta name="author" content="{{ $setting->meta_author }}">
    <meta property="og:title" content="{{ $setting->meta_title }}" />
    <meta property="og:description" content="{{ $setting->meta_description }}">
    <meta property="og:image" content="{{ asset('/settings/' . $setting->meta_image) }}" />
    <meta property="og:url" content="{{ $setting->site_url }}" />
    <meta property="og:site_name" content="{{ $setting->site_name }}">
    <meta name="twitter:url" content="{{ $setting->site_url }}" />
    <meta name="twitter:title" content="{{ $setting->meta_title }}" />
    <meta name="twitter:description" content="{{ $setting->meta_description }}" />
    <meta name="twitter:image" content="{{ asset('/settings/' . $setting->meta_image) }}" />
@endsection

@section('css')

    {{-- Owl Carousel CSS --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" />
<style>
/* Fix for Owl items */
.owl-carousel{
    display: block !impotant;
}
.owl-carousel .item {
    padding: 10px;
    background: #fff;
    border-radius: 6px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}

.owl-carousel .item img {
    display: block;
    width: 100%;
    height: auto;
    border-radius: 6px;
}
</style>


@endsection

@section('content')
<div class="container">
    <div class="row margin150">
        <div class="col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12">
            <div class="col-md-3 padding-zero">
                <h2 class="margin70 text-left">Complete Work</h2>
            </div>
        </div>
    </div>
</div>

<div class="container animate-box fadeInUp animated">
    <div class="col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12">
        {{-- Real Data from Types --}}
        @if (!empty($types))
            @foreach ($types as $type)
                <div class="row mb-4">
                    <div class="col-md-9">
                        <h3>{{ $type->name ?? '' }}</h3>
                    </div>
                    <div class="col-md-3 text-right">
                        <div class="controls">
                            <button class="btn btn-sm btn-outline-secondary prev-{{ $type->id }}">
                                <i class="fa fa-chevron-left"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary next-{{ $type->id }}">
                                <i class="fa fa-chevron-right"></i>
                            </button>
                        </div>
                    </div>
                </div>

                @php
                    $works = works_by_type($type->id);
                @endphp

                <div class="owl-carousel owl-theme" id="carousel-{{ $type->id }}">
                    @if (!empty($works))
                        @foreach ($works as $work)
                            @if (!empty($work->image))
                                <div class="item">
                                    <img src="{{ asset($work->image) }}" alt="{{ $work->name ?? '' }}" style="width:100%; height:auto;" />
                                    <p>{{ $work->name }}</p>
                                </div>
                            @else
                                <div class="item">
                                    <p>No images for {{ $work->name }}</p>
                                </div>
                            @endif
                        @endforeach
                    @else
                        <div class="item"><p>No works found</p></div>
                    @endif
                </div>
            @endforeach
        @endif
    </div>
</div>
@endsection

@section('js')
    {{-- jQuery and Owl Carousel JS --}}
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

    <script>
        $(document).ready(function(){
            // Test Carousel (optional)
            $('#carousel-test').owlCarousel({
                loop: true,
                margin: 10,
                nav: true,
                dots: true,
                items: 1
            });

            // Loop over each type and initialize
            @if (!empty($types))
                @foreach ($types as $type)
                    $('#carousel-{{ $type->id }}').owlCarousel({
                        loop: true,
                        margin: 10,
                        nav: false,
                        dots: false,
                        autoplay: true,
                        autoplayTimeout: 3000,
                        autoplayHoverPause: true,
                        responsive: {
                            0: { items: 1 },
                            600: { items: 2 },
                            1000: { items: 3 }
                        }
                    });

                    // Custom next/prev controls
                    $(".next-{{ $type->id }}").click(function() {
                        $('#carousel-{{ $type->id }}').trigger('next.owl.carousel');
                    });
                    $(".prev-{{ $type->id }}").click(function() {
                        $('#carousel-{{ $type->id }}').trigger('prev.owl.carousel');
                    });
                @endforeach
            @endif
        });
    </script>
@endsection



