@extends('layouts.frontend')
@section('meta_info')
    @php
        $setting = setting();
    @endphp
    <title>{{ $setting->site_title }}</title>
    <meta name="title" content="{{ $setting->site_title }}" />
    <meta name="keywords" content="{{ $setting->meta_keywords }}" />
    <meta name="description" content="{{ $setting->meta_description }}">
    <meta name="author" content="{{ $setting->meta_author }}">
    <meta property="og:title" content="{{ $setting->meta_title }}" />
    <meta property="og:description" content="{{ $setting->meta_description }}">
    <meta property="og:image" content="{{ asset('/settings/' . $setting->meta_image) }}" />
    <meta property="og:url" content="{{ $setting->site_url }}" />
    <meta property="og:site_name" content="{{ $setting->site_name }}">
    <meta name="twitter:url" content="{{ $setting->site_url }}" />
    <meta name="twitter:title" content="{{ $setting->meta_title }}" />
    <meta name="twitter:description" content="{{ $setting->meta_description }}" />
    <meta name="twitter:image" content="{{ asset('/settings/' . $setting->meta_image) }}" />
@endsection

@section('content')
    <div class="container">
        <div class="row margin150">
            <div class="col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12">
                <div class="col-md-3">
                    <h3 class="back-white text-left">Our Client</h3>
                </div>
                <div class="col-md-6"></div>
                <div class="col-md-3"></div>
            </div>
        </div>
    </div>

    {{-- ========= --}}


    <div class="container fadeInUp animated">
        <div class="row">
            <div class="col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12">
                <div class="col-md-3 col-sm-3 col-xs-12">
                    <div class="nav-side-menu">
                        <div class="menu-list">
                            <div class="menu-client-container">
                                <ul id="header_menu menu-content" class="menu-content out">
                                   @if (!empty($types))
                                        @foreach ($types as $type)
                                            <li class="menu-item {{ request()->routeIs('client.single') && request()->slug == $type->slug ? 'active current-menu-item' : '' }}">
                                                <a href="{{ route('client.single', $type->slug) }}" aria-current="page">
                                                    {{ $type->name ?? '' }}
                                                </a>
                                            </li>
                                        @endforeach
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------Part 03------------------------->
                <div class="col-md-9">
                    <div class="row">
                        <div class="col-sm-12">
                            @forelse ($clients as $client)
                                <div class="col-md-3 col-sm-4 col-xs-6 animate-box fadeInUp animated client" style="height: 140px;overflow: hidden;">
                                    <a href="#" target="_blank">
                                        <img width="75" height="75"
                                            src="{{ asset('/img/client/' . $client->logo) }}"
                                            class="img-responsive img-center wp-post-image"
                                            alt="{{ $client->name ?? '' }}"
                                            title="{{ $client->name ?? '' }}" />
                                    </a>
                                    <h5 class="text-center" style="">{{ $client->name ?? '' }}</h5>
                                </div>
                            @empty
                                <div class="col-12">
                                    <p class="text-center text-muted">No clients found.</p>
                                </div>
                            @endforelse

                        </div>
                    </div>
                    <!---Pagination----->
                </div>
                <!-----Logo Item End------->
            </div>
        </div>
    </div>

    {{-- ============ --}}

    <!---------------Part 04----------------->
    <div class="container margin100 fadeInUp animated">
        <div class="col-lg-10 col-lg-offset-1  col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12 padding-zero">
            <!-- Begin Slide 1 -->
            <div class="col-md-6 col-sm-6 col-xs-12 padding-zero">
                <img width="500" height="350" src="{{ asset('/defaults/home_one.jpg') }}"
                    class="img-responsive img-thumbnail wp-post-image" alt="Advertiesment-01" title="Advertiesment-01"
                    srcset="{{ asset('/defaults/home_one.jpg') }} 500w, {{ asset('/defaults/home_one.jpg') }} 300w"
                    sizes="(max-width: 500px) 100vw, 500px" />
            </div>
            <!-- End Slide 1 -->
            <!-- Begin Slide 1 -->
            <div class="col-md-6 col-sm-6 col-xs-12 padding-zero">
                <img width="500" height="350" src="{{ asset('/defaults/home_two.jpg') }}"
                    class="img-responsive img-thumbnail wp-post-image" alt="Advertiesment-02" title="Advertiesment-02"
                    srcset="{{ asset('/defaults/home_two.jpg') }} 500w, {{ asset('/defaults/home_two.jpg') }} 300w"
                    sizes="(max-width: 500px) 100vw, 500px" />
            </div>
            <!-- End Slide 1 -->
        </div>
    </div>
@endsection
