@extends('layouts.frontend')
@section('meta_info')
    @php
        $setting = setting();
    @endphp
    <title>{{ $setting->site_title }}</title>
    <meta name="title" content="{{ $setting->site_title }}" />
    <meta name="keywords" content="{{ $setting->meta_keywords }}" />
    <meta name="description" content="{{ $setting->meta_description }}">
    <meta name="author" content="{{ $setting->meta_author }}">
    <meta property="og:title" content="{{ $setting->meta_title }}" />
    <meta property="og:description" content="{{ $setting->meta_description }}">
    <meta property="og:image" content="{{ asset('/settings/' . $setting->meta_image) }}" />
    <meta property="og:url" content="{{ $setting->site_url }}" />
    <meta property="og:site_name" content="{{ $setting->site_name }}">
    <meta name="twitter:url" content="{{ $setting->site_url }}" />
    <meta name="twitter:title" content="{{ $setting->meta_title }}" />
    <meta name="twitter:description" content="{{ $setting->meta_description }}" />
    <meta name="twitter:image" content="{{ asset('/settings/' . $setting->meta_image) }}" />
@endsection
@section('css')
@endsection
@section('js')
    <script></script>
@endsection

@section('content')
 <div id="clients" class="container">
            <div class="">
                <div class="col-md-12"><h1 id="hero-text">Trust That<br><span>Loops Back</span>.</h1>
                </div>
                
                   <hr>
                    <div class="mt-4"><h4 id="sub_title">"People do not buy goods and services. <br> They buy relations, stories and magic.”</h1>
                    </div>
                      <p class=" qoute">— Seth Godin</p>
                     <hr> 
            </div>
            
            

<div class="container my-5">
    <div class="row g-4 justify-content-center">
        @foreach ($clients as $client)
            <div class="col-6 col-md-4 col-lg-3 my-3">
                <div class="card h-100 border-0 shadow-sm p-3 d-flex align-items-center justify-content-center" 
                     style="cursor: pointer; min-height: 140px; background: #fff;">
                    
                    <img 
                        src="{{ asset('/img/client/' . $client->logo) }}" 
                        class="img-fluid" 
                        alt="{{ $client->name ?? 'Client Logo' }}" 
                        style="max-height: 80px; width: auto; object-fit: contain;"
                    />
                    
                </div>
            </div>
        @endforeach
    </div>
</div>
        </div>
@endsection
