@extends('layouts.frontend')
@section('meta_info')
    <title>About Us | {{ setting('site_title') }}</title>
    <meta name="description" content="{{ setting('meta_description') }}">
    <meta name="keywords" content="{{ setting('meta_keywords') }}">
    <meta name="author" content="{{ setting('meta_author') }}">
@endsection
@section('css')
@endsection
@section('content')
  <div id="about" class="container">
            <div class="my-4 row">
                <div class="col-md-12"><h1 id="hero-text"><span> Behind</span> The Loop.</h1>
                <hr>
                <div class="mt-4"><h4 id="sub_title"><span>“The best way to predict the future is to create it.”</h4>
                    </div>
                    <p class="qoute">— Peter Drucker</p>
                    <hr>
                    <p id="hero-p" class="mt-5">Studio Looper isn’t your average design shop—we’re the creative fix for
                        brands thatBehind
                        refuse to blend in, born in Dhaka and built on guts, caffeine, and big ideas, crafting
                        bold communication that clicks, converts, and keeps people coming back. We
                        don’t do noise; we do clarity, with style, strategy, and just the right dose of mischief,
                        packing a big punch with our small team and giving fewer clients deeper focus,
                        because copy-paste isn’t in our vocabulary. </p> <p id="hero-p"> Ready to ditch the safe and  <span>do
                        something brave?</span></p>
                </div>
            </div>
            <div class="container mt-5">
                <div class="row d-flex justify-content-between align-items-center">
                    <div class="col-md-6">
                    <div class="mb-0"><h6 id="hero-h6" class="mb-0">Let’s Talk <a href="./contact-us"><img
                            class="hero-img" style="width:35px;height:35px;" src="{{ asset('assets/media/Forward Icon_Yellow.a55e1a6f.svg') }}" alt=""></a>
                    </h6></div>
                </div>
                </div>
            </div>
              <hr>
            <!--<div class="container">-->
            <!--    <div class="sec__title text-center my-5">-->
                
            <!--    </div>-->
            <!--</div>-->
            <div class="about__us ml-4">
                <div class="left thumb" style="width: 35%; float: right; margin-left: 20px; margin-top: 10px">
                    <div><img class="card-img-top mr-3" src="{{ asset('assets/img/sabbirimage.png') }}"></div>
                </div>
                <div class="right text">
                        <h1 id="hero-sub">“<span>Design isn’t my job.
                        It’s my playground</span>.”</h1>
                    <p id="hero-p">I’m Sabbir Hossain — the founder and creative spark behind
                        Studio Looper, and a believer that great brands aren’t just
                        seen, they’re felt. For over 15 years, I’ve been crafting ideas
                        that roar across the advertising and branding landscape of
                        Bangladesh, blending strategy with art to help brands show
                        up, stand out, and sell smarter. I’ve poured my passion into
                        everything from corporate identities to digital experiences,
                        with a special love for typography and calligraphy that
                        makes every detail count.
                        Studio Looper was born out of bigger dreams — to build a
                        creative hub where bold thinking, sharp strategy, and
                        flawless design collide. My vision is simple but ambitious: to
                        The best way
                        to predict the future
                        is to create it.
                        – Peter Drucker
                        Link to Contact Page Let’s Loop
                        Home Services About Clients Contact
                        Talent wins games,
                        but teamwork wins
                        championships.
                        — Michael Jordan
                        “Design isn’t my job.
                        It’s my playground.”
                        help brands find their voice and make noise in all the right ways. We’re charting plans to push
                        creative boundaries, collaborate across industries, and become the go-to partner for businesses
                        that dare to be different.
                        But Studio Looper isn’t a one-man show. The real power lies in our core team — a tight group of
                        designers, storytellers, and strategic thinkers who bring creative finesse and relentless
                        curiosity to
                        every project. Together, we’re looping forward, driven to turn ideas into impactful stories that
                        leave a mark. And trust me, the best chapters of our journey are still waiting to be written —
                        and
                        they’re going to be loud.</p>
                </div>
            </div>
            <div class="sec__title text-left my-5">
                <h1 id="hero-text">Meet The Loop ,<span>Troop.</span> 
             </h1>
             <div class="mt-4"><h4 id="sub_title">“Talent wins games, but
teamwork wins championships.”</h1>
                    </div>
                <p class="qoute">— Michael Jordan</p>
            </div>
            <hr>
            <p id="hero-p" class="my-5 w-100">Studio Looper isn’t a one-man show. Behind every bold idea is a crew of creative minds who push
                pixels, shape words, and spin ideas into magic.</p> <p id='hero-p'> <span>Meet the folks who keep the loop spinning.</span></p>

      <div class="team__member ml-4 mb-5">
    <div class="row">

        @foreach(member_query('asc') as $member)
            <div class="col-lg-3">
                <div class="item text-center mb-4">
                    <div class="thumb mb-3">
                       <img src="{{ asset('img/member/' . $member->photo) }}" width="100%">
                    </div>

                    <div class="t__info">
                        <div class="name">
                            <h4 class="txt-primary">{{ $member->name }}</h3>
                            <h5>{{ $member->designation }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach

    </div>
</div>

            <!--<div class="container mt-5">-->
            <!--    <div class="row d-flex justify-content-between align-items-center">-->
            <!--        <div class="col-md-6">-->

            <!--        </div>-->
            <!--        <div class="col-md-6 float-right text-right social__icon">-->
            <!--            <a href=""><i class="fab fa-facebook" aria-hidden="true"></i></a>-->
            <!--            <a href=""><i class="fab fa-linkedin" aria-hidden="true"></i></a>-->
            <!--            <a href=""><i class="fab fa-instagram" aria-hidden="true"></i></a>-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
@endsection
