@extends('layouts.backend')
@section('title')
    Admin | View all posts
@endsection

@section('extra_css')
<style type="text/css">
        
    </style>
@endsection

@section('extra_js')

@endsection

@section('content')
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="card">
                            <div class="card-header py-3 align-items-center justify-content-between">
                                <div class="row">
                                <div class="col-md-4">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                             class="icon icon-tabler icon-tabler-brand-asana" width="38" height="38"
                                             viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                             stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <rect x="4" y="4" width="6" height="6" rx="1"/>
                                            <rect x="4" y="14" width="6" height="6" rx="1"/>
                                            <rect x="14" y="14" width="6" height="6" rx="1"/>
                                            <line x1="14" y1="7" x2="20" y2="7"/>
                                            <line x1="17" y1="4" x2="17" y2="10"/>
                                        </svg>
                                        All Posts
                                    </h6>
                                </div>
                                <div class="col-md-2 d-none">
                                    <div class="search-box">
                                        <div class="input-group">
                                            <form action="{{ route('post.search') }}" role="search" class="d-flex"
                                                  method="GET" style="margin: 0;">
                                                <input type="text" class="form-control" placeholder="Post ID, Headline or Text" name="value">
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8 create__post float-right">
                                    <a href="{{ route('writer.post.create') }}" class="btn btn-primary float-right">
                                        Add New Post</a>
                                </div>
                            </div>

                            </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Headline</th>
                                        <th class="text-center">Time</th>
                                        <th class="text-center">Publisher</th>
                                        <th class="text-center col__action__body" style="width: 180px">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($posts as $post)
                                        <tr>
                                            <td class="text-center">{{$post->id}}</td>
                                            <td class="post__name">
                                                <a href="{{news_url($post)}}" target="_blank">
                                                    <p>{{ Str::limit($post->headline, 55) }}</p>
                                                </a>
                                            </td>
                                            <td class="text-center">{{ Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $post->created_at)->format('H:i/d-m') }}</td>
                                            <td class="text-center">{{  $post->User->name }}</td>
                                            <td class="text-center col__action__body">
                                                <a title="view" target="_blank" href="{{news_url($post)}}"
                                                   class="btn btn-soft-success btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-eye"></i></a>
                                                <a title="edit" href="{{ route('writer.post.edit', ['id' => $post->id])}}"
                                                   class="btn btn-soft-primary btn-icon btn-circle btn-sm"><i
                                                            class="fa fa-edit"></i></a>
                                                <a title="delete" href="{{ route('writer.post.destroy', ['id' => $post->id])}}"  onclick="return confirm('Are you sure to delete this!')" class="btn btn-soft-danger btn-icon btn-circle btn-sm"><i class="fa fa-trash"></i> </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                
                        <div class="d-flex justify-content-left mt-4">
                            {{ $posts->links('pagination::bootstrap-4') }}
                        </div>
                            </div>
                        </div>
                </div>
            </div>
        </div>
@endsection
