@extends('layouts.backend')
@section('title')
    Admin | Website slider setup
@endsection

@section('extra_css')

    <style>
        .slider table img{
            float: none;
            width: 241px !important;
            height: 68px;
            object-fit: cover;
        }
    </style>
@endsection

@section('extra_js')
    <script type="text/javascript">
        $(document).ready(function () {
            $('.getInputFile').change(function (e) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('.profileImgShow').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })
        });
    </script>
@endsection

@section('content')
   
        <div class="container-fluid slider">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">Edit Slider</h6>
                        </div>
                        <div class="card-body">
                            <form role="form" method="post" action="{{ route('slider.update', ['id'=>$slider->id]) }}"
                                  enctype="multipart/form-data">
                                @csrf

                                <div class="form-group">
                                    <label for="title">Title <span class="text-danger"></span></label>
                                    <input class="form-control" name="title" value="{{$slider->title}}"
                                           placeholder="title" type="text" autocomplete="off" required>
                                    <span class="text-danger">{{ $errors->has('title') ? $errors->first('title'):''}}</span>
                                </div>
                                
                                <div class="form-group">
                                    <label for="caption">Caption <span class="text-danger"></span></label>
                                    <textarea class="form-control" rows="3" name="caption"  placeholder="Caption">{!! $slider->caption !!}</textarea>
                                    <span class="text-danger">{{ $errors->has('caption') ? $errors->first('caption'):''}}</span>
                                </div>

                                <div class="form-group">
                                    <label for="link">Link <span class="text-danger"></span></label>
                                    <input class="form-control" name="link" value="{{$slider->link}}"
                                           placeholder="link" type="text" autocomplete="off">
                                    <span class="text-danger">{{ $errors->has('link') ? $errors->first('link'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="possition">Position <span
                                                class="text-danger"></span></label>
                                    <input class="form-control" id="position" type="number" name="position"
                                           value="{{$slider->position}}"
                                           placeholder="Enter position (lower number has high priority)"
                                           min="0">
                                    <span class="text-danger">{{ $errors->has('position') ? $errors->first('position'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="device">Device <span class="text-danger">*</span></label>
                                    <select class="form-control" name="device">
                                        <option @if($slider->device=='desktop') selected @endif value="desktop">
                                            desktop
                                        </option>
                                        <option @if($slider->device=='mobile') selected @endif value="mobile">mobile
                                        </option>
                                    </select>
                                    <span class="text-danger">{{ $errors->has('device') ? $errors->first('device'):''}}</span>
                                </div>

                                <div class="form-group">
                                     <label for="image">Image<small>(982x500)</small><span
                                                class="text-danger">*</span></label>
                                     <div class="custom-file">
                                        <input type="file" class="custom-file-input profile-img-input"  id="image" name="image">
                                        <label class="custom-file-label" for="customFile">Choose file</label>
                                     </div>
                                     <span class="text-danger">{{ $errors->has('image') ? $errors->first('image'):''}}</span>
                                     <div class="pt-1" id="profileLabel" for="image">
                                        <img class="profileImgShow" src="{{ $slider->image ? asset('img/slider/'.$slider->image) : asset('defaults/default3.png')}}">
                                     </div>
                                </div>

                                <button type="submit" class="float-right btn btn-primary">Update</button>
                                <a href="{{ route('slider.index') }}" class="float-right btn btn-danger mr-2">Cancel</a>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Slider</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Title</th>
                                        <th class="text-center">Device</th>
                                        <th class="text-center">Image</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($sliders as $key=> $row)
                                        <tr>
                                            <td class="text-center">{{$row->position}}</td>
                                            <td>{{$row->title}}</td>
                                            <td class="text-center">{{$row->device}}</td>
                                            <td class="text-center"><img src="{{ asset('img/slider/'.$row->image)}}">
                                            </td>
                                            <td class="col__action__body">
                                                <a href="{{ route('slider.edit', ['id' => $row->id])}}"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="{{ route('slider.destroy', ['id' => $row->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div> <!--col-6-->
            </div>
        </div>
    
@endsection
