@extends('layouts.backend')
@section('title')
    Admin | create
@endsection


@section('extra_css')
    <style type="text/css">
        .profileImgShow2,
        .profileImgShow3 {
            width: 80px;
        }
    </style>
@endsection
@section('extra_js')
    <script type="text/javascript">
        //image preview
        $('.profile-img-input2').change(function (e) {
            var reader = new FileReader();
            $('.imageLavel2').html(e.target.files[0].name);
            reader.onload = function (e) {
                $('.profileImgShow2').attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        })

        //image preview
        $('.profile-img-input3').change(function (e) {
            var reader = new FileReader();
            $('.imageLavel3').html(e.target.files[0].name);
            reader.onload = function (e) {
                $('.profileImgShow3').attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        })
    </script>
@endsection
@section('content')
    <div class="container-fluid">
        @include('back.parts.message')
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="col-md-6">
                            <h6 class="m-0 font-weight-bold text-primary">Add Partner</h6>
                        </div>
                        <div class="col-md-6">
                            <a href="{{ route('partner.index') }}" class="btn btn-primary float-right">View All</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form role="form" method="post" action="{{ route('partner.store') }}"
                              enctype="multipart/form-data">
                            @csrf
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label class="" for="name">Name <span class="text-danger">*</span></label>
                                    <input class=" form-control" name="name" placeholder="Name" type="text"
                                           maxlength="250" required>
                                    <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-12"><label class="" for="details">Short Brief <span
                                                class="text-danger">*</span></label>
                                    <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/4.9.11/tinymce.min.js"></script>
                                    <textarea class="content" id="details" name="short_brief" rows="8"
                                              required>  </textarea>
                                    <script>
                                        var editor_config = {
                                            path_absolute: "/",
                                            selector: "#details",
                                            plugins: [
                                                "textcolor advlist autolink lists link image charmap print preview hr anchor pagebreak",
                                                "searchreplace wordcount visualblocks visualchars code fullscreen",
                                                "insertdatetime media nonbreaking save table directionality",
                                                "emoticons template paste textcolor colorpicker textpattern"
                                            ],
                                            toolbar: "forecolor backcolor insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media",
                                            relative_urls: false,
                                            file_browser_callback: function (field_name, url, type, win) {
                                                var x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth;
                                                var y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

                                                var cmsURL = editor_config.path_absolute + 'laravel-filemanager?field_name=' + field_name;
                                                if (type == 'image') {
                                                    cmsURL = cmsURL + "&type=Images";
                                                } else {
                                                    cmsURL = cmsURL + "&type=Files";
                                                }

                                                tinyMCE.activeEditor.windowManager.open({
                                                    file: cmsURL,
                                                    title: 'Filemanager',
                                                    width: x * 0.8,
                                                    height: y * 0.8,
                                                    resizable: "yes",
                                                    close_previous: "no"
                                                });
                                            }
                                        };
                                        tinymce.init(editor_config);
                                    </script>
                                    <span class="text-danger">{{ $errors->has('short_brief') ? $errors->first('short_brief'):''}}</span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="mb-1" for="photo">Logo <span class="text-danger"></span></label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input profile-img-input3" id="photo"
                                           name="logo">
                                    <label class="custom-file-label imageLavel3" for="customFile">Choose file</label>
                                </div>
                                <span class="text-danger">{{ $errors->has('logo') ? $errors->first('logo'):''}}</span>
                                <div class="pt-1" id="profileLabel" for="photo">
                                    <img class="profileImgShow3" src="{{ asset('defaults/default3.png')}}">
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="possition">Position <span
                                            class="text-danger">*</span></label>
                                <input class="form-control" type="number" min="1" name="position" required="required"
                                       placeholder="Enter position (lower number has high priority)"
                                       id="position">
                                <span class="text-danger">{{ $errors->has('position') ? $errors->first('position'):''}}</span>
                            </div>
                            <button type="submit" class="float-right btn btn-primary">Create</button>
                        </form>
                    </div>
                </div>
            </div> <!--col-5-->
        </div>
    </div>
@endsection

