@extends('layouts.backend')
@section('title')
    Admin | Visitors Inquiry
@endsection

@section('extra_css')

@endsection

@section('extra_js')

@endsection

@section('content')
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="card">
                            <div class="card-header py-3 align-items-center justify-content-between">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h6 class="m-0 font-weight-bold text-primary">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                 class="icon icon-tabler icon-tabler-brand-asana" width="28" height="28"
                                                 viewBox="0 0 24 24" stroke-width="1" stroke="#ff9300" fill="none"
                                                 stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                <rect x="4" y="4" width="6" height="6" rx="1"/>
                                                <rect x="4" y="14" width="6" height="6" rx="1"/>
                                                <rect x="14" y="14" width="6" height="6" rx="1"/>
                                                <line x1="14" y1="7" x2="20" y2="7"/>
                                                <line x1="17" y1="4" x2="17" y2="10"/>
                                            </svg>
                                            All Message
                                        </h6>
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Message</th>
                                        <th class="text-center">Time</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($messages as $item)
                                        <tr>
                                            <td>{{$item->name}}</td>
                                            <td>{{$item->email}}</td>
                                            <td>{{ Str::limit($item->message,50) }}</td>
                                            <td class="text-center">{{ view_date_format($item->created_at,'d-m-Y H:i') }}</td>
                                            <td class="col__action__body">
                                                <a title="view" href="{{ route('message.view', ['id' => $item->id])}}"
                                                   class="btn btn-success btn-sm">View</a>
                                                <a title="delete" href="{{ route('message.destroy', ['id' => $item->id])}}"  onclick="return confirm('Are you sure to delete this!')" class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                
                        <div class="d-flex justify-content-left mt-4">
                            {{ $messages->links('pagination::bootstrap-4') }}
                        </div>
                            </div>
                        </div>
                </div>
            </div>
        </div>
@endsection


