@extends('layouts.backend')
@section('title')
    Admin | create 
@endsection

@section('content')
<div class="container-fluid">
    @include('back.parts.message')
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <div class="col-md-6">
                        <h6 class="m-0 font-weight-bold text-primary">Add Client</h6>
                    </div>
                    <div class="col-md-6">
                        <a href="{{ route('client.index') }}" class="btn btn-primary float-right">View All</a>
                        <a href="{{ route('client.type.index') }}" class="btn btn-primary float-right mr-2">Type</a>
                    </div>
                </div>
                <div class="card-body">
                    <form role="form" method="post" action="{{ route('client.store') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="" for="client_type_id">Type <span class="text-danger">*</span></label>
                                <select class="form-control select2" name="client_type_id" id="client_type_id" required>
                                    <option value="">-Select Type-</option>
                                    @foreach ($types as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                                <span class="text-danger">{{ $errors->has('client_type_id') ? $errors->first('client_type_id'):''}}</span>
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-12">
                                <label class="" for="name">Name <span class="text-danger">*</span></label>
                                <input class=" form-control" name="name" placeholder="Name" type="text"
                                       maxlength="200" required>
                                <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                            </div>
                        </div>
                        {{-- <div class="form-group row">
                            <div class="col-md-12">
                                <label class="" for="web_address">Web Address <span class="text-danger"></span></label>
                                <textarea class="form-control" rows="5" name="web_address" placeholder="Web Address"></textarea>
                                <span class="text-danger">{{ $errors->has('web_address') ? $errors->first('web_address'):''}}</span>
                            </div>
                        </div> --}}
                        <div class="form-group">
                         <label class="mb-1" for="photo">Logo <span class="text-danger">*</span></label>
                         <div class="custom-file">
                            <input type="file" class="custom-file-input profile-img-input" id="photo" name="logo" required>
                            <label class="custom-file-label" for="customFile">Choose file</label>
                         </div>
                         <span class="text-danger">{{ $errors->has('logo') ? $errors->first('logo'):''}}</span>
                         <div class="pt-1" id="profileLabel" for="photo">
                            <img class="profileImgShow" src="{{ asset('defaults/default3.png')}}">
                         </div>
                        </div>
                        
                        {{-- <div class="form-group">
                            <label for="possition">Position <span
                                        class="text-danger"></span></label>
                                <input class="form-control" type="number" min="1" name="position" required="required" placeholder="Enter position (lower number has high priority)"
                                       id="position">
                                <span class="text-danger">{{ $errors->has('position') ? $errors->first('position'):''}}</span>
                        </div> --}}

                        <button type="submit" class="float-right btn btn-primary">Create</button>
                    </form>
                </div>
            </div>
        </div> <!--col-5-->
    </div>
</div>
@endsection

