@extends('layouts.backend')
@section('title')
    Admin | All Client Type
@endsection

@section('content')
   
        <div class="container-fluid">
            @include('back.parts.message')
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                      <h6 class="m-0 font-weight-bold text-primary">Add Client Type</h6>
                    </div>
                        <div class="card-body">
                            <form role="form" method="post" action="{{ route('client.type.store') }}"
                                  enctype="multipart/form-data">
                                @csrf

                                <div class="form-group">
                                    <label for="name">Name <span class="text-danger">*</span></label>
                                    <input class=" form-control" name="name" type="text">
                                    <span class="text-danger">{{ $errors->has('name') ? $errors->first('name'):''}}</span>
                                </div>
                                <div class="form-group">
                                    <label for="slug">Slug</label>
                                    <input class=" form-control" name="slug" type="text">
                                    <span class="text-danger">{{ $errors->has('slug') ? $errors->first('slug'):''}}</span>
                                </div>
                                <button type="submit" class="float-right btn btn-primary">Create</button>
                            </form>
                        </div>
                    </div>
                </div> <!--col-6-->

                <div class="col-lg-8">
                    <div class="card mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                          <h6 class="m-0 font-weight-bold text-primary">All Client Type</h6>
                        </div>
                            <div class="table-responsive">
                                <table class="table align-items-center table-flush">
                                    <thead class="thead-light">
                                    <tr>
                                        <th class="text-center col__id">ID</th>
                                        <th>Name</th>
                                        <th>Slug</th>
                                        <th class="col__action__body">Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($types as $row)
                                        <tr>
                                            <td class="text-center">{{$row->id}}</td>
                                            <td>
                                                {{$row->name}}
                                            </td>
                                            <td>{{$row->slug}}</td>
                                            <td class="col__action__body">
                                                <a href="{{ route('client.type.edit', ['id' => $row->id])}}"
                                                   class="btn btn-info btn-sm">Edit</a>
                                                <a href="{{ route('client.type.destroy', ['id' => $row->id])}}"
                                                   onclick="return confirm('Are you sure to delete this!')"
                                                   class="btn btn-danger btn-sm">Delete</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        
                    </div>
                </div> <!--col-6-->

            </div>
        </div>
    
@endsection
