<?php 
/**
 * Get the bootstrap!
 * (Update path to use cmb2 or CMB2, depending on the name of the folder.
 * Case-sensitive is important on some systems.)
 */
require_once __DIR__ . '/cmb2/init.php';

add_action('cmb2_admin_init','idea_holiday_cmb2');

function idea_holiday_cmb2(){
$prefix = '_idea-holiday_';					
//Career
	$package = new_cmb2_box( array(
		'id'            => 'career_metabox',
		'title'         => __( 'Career Published', 'idea_holiday' ),
		'object_types'  => array( 'package', ), // Post type
		'context'       => 'normal',
		'priority'      => 'high',
		'show_names'    => true, // Show field names on the left
	) );
	// Regular text field 
	$package->add_field( array(
		'name'       => __( 'Career Position', 'idea_holiday' ),
		'desc'       => __( 'Type Career Position Here', 'idea_holiday' ),
		'id'         => $prefix . 'position',
		'type'       => 'text'
	) );	
//Our Service
	$service = new_cmb2_box( array(
		'id'            => 'service_metabox',
		'title'         => __( 'Service Metabox', 'idea_holiday' ),
		'object_types'  => array( 'service', ), // Post type
		'context'       => 'normal',
		'priority'      => 'high',
		'show_names'    => true, // Show field names on the left
	) );
	// Regular text field
	$service->add_field( array(
		'name'       => __( 'Service URL', 'idea_holiday' ),
		'desc'       => __( 'Service URL Here', 'idea_holiday' ),
		'id'         => $prefix . 'url',
		'type'       => 'text_url'
	) );
//Client
	$client = new_cmb2_box( array(
		'id'            => 'client_metabox',
		'title'         => __( 'Client Metabox', 'idea_holiday' ),
		'object_types'  => array( 'client', ), // Post type
		'context'       => 'normal',
		'priority'      => 'high',
		'show_names'    => true, // Show field names on the left
	) );
	// Regular text field
	$client->add_field( array(
		'name'       => __( 'Client URL', 'idea_holiday' ),
		'desc'       => __( 'Client URL Here', 'idea_holiday' ),
		'id'         => $prefix . 'url',
		'type'       => 'text_url'
	) );	
}