<?php

namespace App\Http\Controllers;

use App\Models\WorkType;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class WorkTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $types = WorkType::orderBy('id','asc')->get();
        return view('back.work-type.index', compact('types'));
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:250',
        ]);
        $item = new WorkType();
        $item->name = $request->name;

        if($request->slug == null){
            $item->slug = Str::slug($request->name);
        }else{
            $item->slug = Str::slug($request->slug);
        }
        $item->save();
        return Redirect()->back()->with('success','inserted successfully');
    }
  
    public function edit( $id)
    {
        $types = WorkType::orderBy('id','asc')->get();
        $item = WorkType::findOrfail($id);
        return view('back.work-type.edit', compact('item','types'));
    }
    
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:250',
        ]);
        $item =  WorkType::findOrfail($id);
        $item->name = $request->name;
        if($request->slug == null){
            $item->slug = Str::slug($request->name);
        }else{
            $item->slug = Str::slug($request->slug);
        }
        $item->save();
        return Redirect()->route('work.type.index')->with('success','updated successfully');
    }
   
    public function destroy($id)
    {
        $item = WorkType::findOrFail($id);
        $works = $item->works()->count();
        $completeWorks = $item->completeWorks()->count();
        $total = $works  + $completeWorks;
        
        if ($total > 0 ) {
            return redirect()
                ->route('work.type.index')
                ->with('danger', 'This work type cannot be deleted because it has related works.');
        }

        $item->delete();

        return redirect()
            ->route('work.type.index')
            ->with('success', 'Deleted successfully');
    }

}
