<?php

namespace App\Http\Controllers;

use App\Models\Event;
use App\Models\PaymentInfo;
use Illuminate\Http\Request;

class PaymentInfoShow extends Controller
{
    public function index(){
        $events = Event::orderBy('id','desc')->get();
        $items = PaymentInfo::where('sp_code',1000)->orderBy('id','desc')->paginate(20);
        return view('back.paymentinfo.index',compact('items','events'));
    }

    public function filter(Request $request){
        $event_id = $request->event_id;
        $events = Event::orderBy('id','desc')->get();
        if($event_id == 0){
            $items = PaymentInfo::where('sp_code',1000)->orderBy('id','desc')->paginate(20);
        }else{
            $items = PaymentInfo::where('sp_code',1000)->where('event_id',$event_id)->orderBy('id','desc')->paginate(20);
        }
        return view('back.paymentinfo.index',compact('items','events','event_id'));
    }
    
    public function print(Request $request)
    {
        $event_id = $request->event_id;
        if($event_id == 0){
            $eventName = 'All Events';
            $totalRegistered = PaymentInfo::where([['sp_code',1000]])->whereNotNull('id')->count('id') ?? 0;
            $items = PaymentInfo::where('sp_code',1000)->orderBy('id','asc')->get();
        }else{
            $eventName = Event::where('id',$event_id)->first()->headline  ?? '';
            $totalRegistered = PaymentInfo::where([['sp_code',1000],['event_id',$event_id]])->whereNotNull('id')->count('id') ?? 0;
            $items = PaymentInfo::where('sp_code',1000)->where('event_id',$event_id)->orderBy('id','asc')->get();
        }
        // Return the data as JSON response for client-side rendering
        return response()->json([
            'items' => $items,
            'eventName' => $eventName,
            'totalRegistered' => $totalRegistered
        ]);
    }
    
    public function delete($id){
        $items = PaymentInfo::find($id);
        $items->delete();
        return Redirect()->back()->with('success',  'Deleted successfully');
    }
    
    
}
