<?php
namespace App\Http\Controllers;
use App\Models\Product;
use App\Models\ParentCategory;
use App\Models\Category;
use App\Models\SubCategory;
use App\Models\ContactMessage;
use App\Models\Tag;
use App\Models\Slider;
use App\Models\GeneralSetting;
use App\Models\Post;
use App\Models\Page;
use App\Models\VideoGallery;
use \App\Models\Message;
use \App\Models\Magazine;
use \App\Models\Service;
use \App\Models\Client;
use \App\Models\Testimonial;
use \App\Models\Partner;
use \App\Models\Member;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Pagination\CursorPaginator;
use Stevebauman\Location\Facades\Location;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Auth;
use DB;
use URL;
class FrontendController extends Controller
{  
    public function home(Request $request){
         $setting = \App\Models\GeneralSetting::orderBy('id','desc')->first();
        $categories = Category::orderby('position','asc')->get();
        return view('_front.pages.home', compact( 'categories'));
    }
    public function members($type){
        return view('_front.pages.members',compact('type'));
    }
    public function aboutUs(){
        return view('_front.pages.about_us');
    }
    public function contactUs(){
        return view('_front.pages.contact_us');
    }
    public function clients(){
        return view('_front.pages.clients');
    }
    public function testimonials(){
        return view('_front.pages.testimonials');
    }
    public function partners(){
        return view('_front.pages.partners');
    }
    public function team(){
        return view('_front.pages.team');
    }
    public function single_partner($slug){
        $partner = Partner::where('slug', $slug)->first();
        return view('_front.pages.single_partner',compact('partner'));
    }
    
    // public function services(){
    //     $services = Service::orderby('id','asc')->get();
    //     return view('_front.pages.services', compact( 'services'));
    // }
    public function singleService($slug){
        $service = Service::where('slug',$slug)->first();
        return view('_front.pages.singleService', compact('service'));
    }

    public function photoGallery(){
        return view('_front.photo.photos');
    }
    public function videoGallery(){
        return view('_front.video.videos');
    }
    public function singleVideoGallery($id)
    {
        $video = VideoGallery::find($id);
        $video->view_count = $video->view_count + 1;
        $video->save();
        return view('_front.video.single', compact('video'));
    }
    
    
    
    public function messageStore(Request $request){
        date_default_timezone_set("Asia/Dhaka");
        $request->validate([
            'name' => 'required|max:100',
            'email' => 'max:250',
            'subject' => 'required|max:500',
            'phone' => 'max:20',
            'message' => 'required',
        ]);

        $message =  new Message();
        $message->name     = $request->name;
        $message->email     = $request->email;
        $message->subject     = $request->subject;
        $message->phone     = $request->phone;
        // $message->company_name     = $request->company_name;
        $message->message     = $request->message;
        $message->save();
        return Redirect()->back()->with('success',  'Your message successfully granted');
        
    }
    
    public function singlePage($slug){
        $page = Page::where('slug', $slug)->first();
        if(!empty($page)){
            return view('_front.pages.single_page', compact('page'));
        }
        else{
            return view('errors.404');
        }
    }
    
    public function allPost(){
        $posts = Post::where('status', 1)->orderBy('created_at', 'desc')->Paginate(20);
        return view('_front.pages.all_posts', compact('posts'));
    }
    public function categoryPost($slug)
    {
        $category = Category::where('slug', $slug)->first();
        if(!empty($category)){
            $posts = Category::find($category->id)->Posts()->orderBy('created_at', 'desc')->take(4)->get();
            return view('_front.pages.category', compact('category', 'posts'));
        }else if($slug == 'contact-us'){
            return view('_front.pages.contact_us');
        }else if($category = 'application'){
            $studentclasses = studentclass::orderby('position','asc')->get();
            return view('_front.student.create', compact('studentclasses'));
        }
        else{
            return view('errors.404');
        }
    }
    
    public function singlePost($category, $id)
    {   
        $post = Post::find($id);
        $category = Category::where('slug', $category)->first();
        if($post != null && $category!= null){
            $post->view_count = $post->view_count + 1;
            $post->save();
            return view('_front.pages.single_post', compact('post', 'category'));
        }else{
            return view('errors.404');
        }
    }
    public function singleMember($id, $name)
    {   
        $member = Member::find($id);
        if(!empty($member)){
            return view('_front.pages.singleMember', compact('member'));
        }else{
            return view('errors.404');
        }
    }
    public function leadership(){
        return view('_front.pages.leadership');
    }
    public function service(){
        return view('_front.pages.services');
    }
    
    public function donate(){
        return view('_front.pages.donate');
    }
    public function project(){
        $projects = Service::orderby('id','asc')->get();
        return view('_front.pages.project',compact('projects'));
    }

    
    public function search(Request $request)
    {
        $query = $request->x;
        $items = Post::where('headline', 'LIKE', '%' . $query . '%')->orWhere('content', 'LIKE', '%' . $query . '%')->paginate(10);
        $items->appends($request->all());
        return view('_front.pages.search', compact('items', 'query'));
    }
    
}