<?php

namespace App\Http\Controllers;

use App\Models\WorkType;
use Illuminate\Support\Str;
use App\Models\CompleteWork;
use Illuminate\Http\Request;

class CompleteWorkController extends Controller
{
    
    public function index()
    {
        $items = CompleteWork::orderby('id','desc')->paginate(10);
        return view('back.complete-work.index', compact('items'));
    }

    public function create()
    {
        $types = WorkType::orderBy('id','desc')->get();
        return view('back.complete-work.create', compact('types'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:200',
            'work_type_id' => 'required',
            'description' => 'nullable|max:20000',
            'image' => 'image|mimes:jpg,jpeg,png,gif|max:2048',
        ]);

        $item = new CompleteWork();
        $item->work_type_id = $request->work_type_id;
        $item->name = $request->name;
        $item->slug = Str::slug($request->name);
        $item->description = $request->description;
        
        if($request->hasFile('image')){
            $file = $request->file('image');
            $filename = uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('work/images'), $filename);
            $imagePath = 'work/images/' . $filename;
            $item->image = $imagePath;
        }
        
        $item->save();
        return Redirect()->back()->with('success','inserted successfully');
    }


    public function edit( $id)
    {
        $work = CompleteWork::find($id);
        $types = WorkType::orderBy('id','desc')->get();
        return view('back.complete-work.edit', compact('types','work'));
    }

    public function update(Request $request, $id)
    {
        $item = CompleteWork::findOrFail($id);

        $request->validate([
            'work_type_id' => 'required|exists:work_types,id',
            'name' => 'required|max:200',
            'image' => 'image|mimes:jpg,jpeg,png,gif|max:2048',
        ]);

        $item->work_type_id = $request->work_type_id;
        $item->name = $request->name;
        $item->slug = Str::slug($request->name);
        $item->description = $request->description;
        
        if($request->hasFile('image')){
            $file = $request->file('image');
            $filename = uniqid() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('work/images'), $filename);
            $imagePath = 'work/images/' . $filename;
            $item->image = $imagePath;
        }
        
        $item->save();
        return redirect()->route('complete.work.index')->with('success', 'Updated successfully');
    }

    public function destroy( $id)
    {
        $work = CompleteWork::find($id);
        $work->delete();
        return redirect()->route('complete.work.index')->with('success', 'Deleted successfully');
    }
    
}
