<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\ClientType;
use Illuminate\Http\Request;

class ClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $items = Client::orderby('id','desc')->paginate(10);
        return view('back.client.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        $types = ClientType::orderBy('id','desc')->get();
        return view('back.client.create', compact('types'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'client_type_id' => 'required',
            'name' => 'required|max:250',
            'logo' => 'required',
        ]);
        $item = new Client();
        $item->client_type_id = $request->client_type_id;
        $item->name = $request->name;
        $item->web_address = $request->web_address;
        $item->position = $request->position;
        if($request->hasfile('logo')){
            $file = $request->file('logo');
            $fileName = time().'.'.$file->getClientOriginalExtension();
             $file->move(public_path('/img/client/'), $fileName);
            $item->logo = $fileName;
        }
        $item->save();
        return Redirect()->back()->with('success','inserted successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function show(Client $client)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function edit( $id)
    {
        $item = Client::findOrfail($id);
        $types = ClientType::orderBy('id','desc')->get();
        return view('back.client.edit', compact('item', 'types'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'client_type_id' => 'required',
            'name' => 'required|max:250',
        ]);
        $item =  Client::findOrfail($id);
        $item->client_type_id = $request->client_type_id;
        $item->name = $request->name;
        $item->web_address = $request->web_address;
        $item->position = $request->position;
        if($request->hasfile('logo')){
            $file = $request->file('logo');
            $fileName = time().'.'.$file->getClientOriginalExtension();
             $file->move(public_path('/img/client/'), $fileName);
            $item->logo = $fileName;
        }
        $item->save();
        return Redirect()->route('client.index')->with('success','updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Client  $client
     * @return \Illuminate\Http\Response
     */
    public function destroy( $id)
    {
        $item =  Client::findOrfail($id);
        $item->delete();
        return Redirect()->route('client.index')->with('success','Deleted successfully');
    }
}
