@extends('layouts.frontend')
@php
    $setting = setting();
@endphp
<title>Fund Raise | {{ $setting->site_title }}</title>
<meta name="title" content="Fund Raise | {{ $setting->site_title }}"/>
<meta name="keywords" content="{{ $setting->meta_keywords }}"/>
<meta name="description" content="{{ $setting->meta_description }}">
<meta name="author" content="{{$setting->meta_author}}">
<meta property="og:title" content="Fund Raise | {{ $setting->site_title }}"/>
<meta property="og:description" content="{{ $setting->meta_description }}">
<meta property="og:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
<meta property="og:url" content="{{$setting->site_url}}"/>
<meta property="og:site_name" content="{{ $setting->site_name }}">
<meta name="twitter:url" content="{{ $setting->site_url }}"/>
<meta name="twitter:title" content="Fund Raise | {{ $setting->site_title }}"/>
<meta name="twitter:description" content="{{ $setting->meta_description }}"/>
<meta name="twitter:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
@section('css')

@endsection
@section('content')
    <section class="donate__banner bg-position-start-bottom bg-no-repeat"
             style="background-color: #ffc6ce; background: url(/img/banner__donate.jpg) center/cover;">
        <div class="container py-lg-5">
            <div class="row">
                <div class="col-xl-5 col-lg-5 col-md-7 offset-md-1 offset-xl-0">
                    <h2 class="display-4 pb-4 text-center text-md-start"><span>RAISE FUND</span>
                        TO SAVE HUMANITY</h2>
                    <div class="d-flex align-items-center justify-content-center justify-content-md-start"><a
                                class="btn-video me-3" href=""
                                data-sub-html="<h6 class=&quot;fs-sm &quot;>Goby Electric Toothbrush Review</h6>"
                                lg-uid="lg0"></a><span style="max-width: 15rem;">Click here to see our activities</span>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="sec__payment bg-secondary position-relative">
        <div class="container d-flex justify-content-center">
            <div class="row">
                <div class="col-md-6 mx-auto">
                    <div class="row justify-content-center text-center pt-xl-2 pb-4 mb-1 mb-lg-3">
                        <h1 class="mb-4"><span class="text-gradient-primary">Payment Information</span></h1>
                        <p class="mb-0">Like what you have seen? Let’s get started. Just fill in a few details and we
                            will get in touch as soon as possible.</p>
                    </div>

                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="m-0 p-0">
                                @foreach($errors->all() as $error)
                                    <li class="list-group-item">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    <form class="row needs-validation " method="POST" action="{{ route('donation') }}">

                        @csrf
                        <div class="col-sm-6 mb-3">
                            <label for="fn" class="form-label">First Name <span class="text-danger">*</span></label>
                            <input type="text" id="fn" class="form-control @error('first_name') field-invalid @enderror"
                                   value="{{ old('first_name') }}" name="first_name" maxlength="100" required>
                            @error('first_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-sm-6 mb-3">
                            <label for="ln" class="form-label">Last Name <span class="text-danger">*</span></label>
                            <input type="text" id="ln" class="form-control @error('last_name') field-invalid @enderror"
                                   value="{{ old('last_name') }}" name="last_name" maxlength="100" required>
                            @error('last_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row">
                            <div class="col-6 mb-3">
                                <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                <input type="email" id="email"
                                       class="form-control @error('email') field-invalid @enderror"
                                       value="{{ old('email') }}" name="email" maxlength="100" required>
                                @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-6 mb-3">
                                <label for="phone" class="form-label">Phone No <span
                                            class="text-danger">*</span></label>
                                <input type="text" id="phone"
                                       class="form-control @error('phone') field-invalid @enderror"
                                       value="{{ old('phone') }}" name="phone" maxlength="18"
                                       oninput="formatPhoneNum(this)" required>
                                @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">Address <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('address') field-invalid @enderror"
                                   value="{{ old('address') }}" name="address" maxlength="100" required>
                            @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">City <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('city') field-invalid @enderror"
                                   value="{{ old('city') }}" name="city" maxlength="50" required>
                            @error('city')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Amount <span class="text-danger">*</span></label>
                            <input type="number" class="form-control @error('amount') field-invalid @enderror"
                                   name="amount" min="0" required>
                            @error('amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-12 text-center pt-2 pt-md-3 pt-lg-4">
                            <button type="submit" class="btn btn-outline-primary">Continue <i class="bx bx-right-arrow-alt fs-xl ms-2"></i></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection